/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.simmetrics.StringMetric;
import org.simmetrics.metrics.Math;
import org.simmetrics.metrics.functions.MatchMismatch;
import org.simmetrics.metrics.functions.Substitution;

public final class NeedlemanWunch
implements StringMetric {
    private static final Substitution MATCH_0_MISMATCH_1 = new MatchMismatch(0.0f, -1.0f);
    private final Substitution substitution;
    private final float gapValue;

    public NeedlemanWunch() {
        this(-2.0f, MATCH_0_MISMATCH_1);
    }

    public NeedlemanWunch(float gapValue, Substitution substitution) {
        Preconditions.checkArgument((gapValue <= 0.0f ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)substitution);
        this.gapValue = gapValue;
        this.substitution = substitution;
    }

    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        float maxDistance = (float)java.lang.Math.max(a.length(), b.length()) * java.lang.Math.max(this.substitution.max(), this.gapValue);
        float minDistance = (float)java.lang.Math.max(a.length(), b.length()) * java.lang.Math.min(this.substitution.min(), this.gapValue);
        return (-this.needlemanWunch(a, b) - minDistance) / (maxDistance - minDistance);
    }

    private float needlemanWunch(String s, String t) {
        if (Objects.equals(s, t)) {
            return 0.0f;
        }
        if (s.isEmpty()) {
            return -this.gapValue * (float)t.length();
        }
        if (t.isEmpty()) {
            return -this.gapValue * (float)s.length();
        }
        int n = s.length();
        int m = t.length();
        float[] v0 = new float[m + 1];
        float[] v1 = new float[m + 1];
        for (int j = 0; j <= m; ++j) {
            v0[j] = j;
        }
        for (int i = 1; i <= n; ++i) {
            v1[0] = i;
            for (int j = 1; j <= m; ++j) {
                v1[j] = Math.min(v0[j] - this.gapValue, v1[j - 1] - this.gapValue, v0[j - 1] - this.substitution.compare(s, i - 1, t, j - 1));
            }
            float[] swap = v0;
            v0 = v1;
            v1 = swap;
        }
        return v0[m];
    }

    public String toString() {
        return "NeedlemanWunch [costFunction=" + String.valueOf(this.substitution) + ", gapCost=" + this.gapValue + "]";
    }
}

